% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLMS_GLIdiff.R
\name{getLMS_GLIdiff}
\alias{getLMS_GLIdiff}
\title{Calculate L,M,S of GLI diffusing capacity (2017) equations}
\usage{
getLMS_GLIdiff(age, height, gender = 1, param = "TLCO", SI = TRUE)
}
\arguments{
\item{age}{Age in years}

\item{height}{Height in meters}

\item{gender}{Gender (1 = male, 2 = female) or a factor with two levels (first = male). Default is 1.}

\item{param}{A character vector, containing one of more of the following parameters (case insensitive):
"TLCO", "KCO" or "VA"}

\item{SI}{(default TRUE) Use SI (mmol/min/kPa) or traditional (ml/min/mmHg) units?}
}
\value{
A data.frame with L, M and S, for every patient and every parameter requested
}
\description{
This function calculates the L,M,S using the GLI diffusing capacity (2017, 
corrected 2020) equations (Stanojevic et al, Eur Respir J 2017). The output
of this function is used in calculating LLN and predicted values for TLCO
(transfer factor of the lung for carbon monoxide), KCO (transfer coefficient 
of the lung for carbon monoxide) and VA (alveolar volume).
Checking of the input is also performed here.
}
\details{
This is for internal use only.

Arguments \code{age}, \code{height} and \code{gender} are vectors
of equal length, or of length one, in which case the value is recycled; if the four vectors are
not of equal length, the function stops with an error.
}
\keyword{internal}
