% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collections-query.R
\name{collections}
\alias{collections}
\title{Endpoint functions}
\usage{
collections(q, collection_id = NULL, limit = NULL)
}
\arguments{
\item{q}{a \code{rstac_query} object expressing a STAC query
criteria.}

\item{collection_id}{a \code{character} collection id to be retrieved.}

\item{limit}{an \code{integer} defining the maximum number of results
to return. If not informed, it defaults to the service implementation.}
}
\value{
A \code{rstac_query} object with the subclass \code{collections} for
\verb{/collections/} endpoint, or a \code{collection_id} subclass for
\code{/collections/{collection_id}} endpoint, containing all search field
parameters to be provided to STAC API web service.
}
\description{
The \code{collections} function implements the WFS3 \verb{/collections}
and \code{/collections/\{collectionId\}} endpoints.

Each endpoint retrieves specific STAC objects:
\itemize{
\item \verb{/collections}: Returns a list of STAC Collections published in
the STAC service
\item \code{/collections/\{collectionId\}}: Returns a single STAC
Collection object
}
}
\examples{
\dontrun{
 stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
   collections() \%>\%
   get_request()

 stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
   collections(collection_id = "CB4-16D-2") \%>\%
   get_request()
}

}
\seealso{
\code{\link[=get_request]{get_request()}}, \code{\link[=post_request]{post_request()}}, \code{\link[=items]{items()}}
}
