% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_interval.R
\name{posterior_interval}
\alias{posterior_interval}
\alias{posterior_interval.default}
\title{Generic function and default method for posterior uncertainty intervals}
\usage{
posterior_interval(object, ...)

\method{posterior_interval}{default}(object, prob = 0.9, ...)
}
\arguments{
\item{object}{The object to use.}

\item{...}{Arguments passed to methods. See the methods in the \pkg{rstanarm}
package for examples.}

\item{prob}{A number \eqn{p \in (0,1)}{p (0 < p < 1)} indicating the desired
probability mass to include in the intervals.}
}
\value{
\code{posterior_interval()} methods should return a matrix with two
columns and as many rows as model parameters (or a subset of parameters
specified by the user). For a given value of \code{prob}, \eqn{p}, the
columns correspond to the lower and upper \eqn{100p}\\% interval limits and
have the names \eqn{100\alpha/2}\\% and \eqn{100(1 - \alpha/2)}\\%, where
\eqn{\alpha = 1-p}. For example, if \code{prob=0.9} is specified (a
\eqn{90}\\% interval), then the column names would be \code{"5\%"} and
\code{"95\%"}, respectively.

The default method just takes \code{object} to be a matrix (one column per
parameter) and computes quantiles, with \code{prob} defaulting to \code{0.9}.
}
\description{
These intervals are often referred to as credible intervals, but we use the
term uncertainty intervals to highlight the fact that wider intervals
correspond to greater uncertainty. See
\href{https://mc-stan.org/rstanarm/reference/posterior_interval.stanreg.html}{posterior_interval.stanreg()}
in the \pkg{rstanarm} package for an example.
}
\examples{
# Default method takes a numeric matrix (of posterior draws)
draws <- matrix(rnorm(100 * 5), 100, 5) # fake draws
colnames(draws) <- paste0("theta_", 1:5)
posterior_interval(draws)

# Also see help("posterior_interval", package = "rstanarm")

}
\seealso{
\itemize{
\item The \pkg{rstanarm} package (\href{https://mc-stan.org/rstanarm/}{mc-stan.org/rstanarm})
for example methods
(\href{https://CRAN.R-project.org/package=rstanarm}{CRAN},
\href{https://github.com/stan-dev/rstanarm}{GitHub}).
}

\itemize{
\item Guidelines and recommendations for developers of \R packages
interfacing with Stan and a demonstration getting a simple package working
can be found in the vignettes included with \pkg{rstantools} and at
\href{https://mc-stan.org/rstantools/articles/}{mc-stan.org/rstantools/articles}.
}
}
