% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counts_to_cases.R
\name{counts_to_cases}
\alias{counts_to_cases}
\title{Convert a Table of Counts into a Data Frame of cases}
\usage{
counts_to_cases(x, count.col = "Freq")
}
\arguments{
\item{x}{a contingency table or a data frame}

\item{count.col}{the name of the column containing the counts. Default is "Freq".}
}
\value{
a data frame of cases
}
\description{
converts a contingency table or a data frame of counts into a
  data frame of individual observations.
}
\examples{
# Create a cross-tabulation demo data
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
xtab <- as.table(
  rbind(c(20, 5), c(16,9))
)
dimnames(xtab) <- list(
  before = c("non.smoker", "smoker"),
  after = c("non.smoker", "smoker")
)
xtab

# Convert into a data frame of cases
#\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%\%
df <- counts_to_cases(xtab)
head(df)

}
