% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{lp}
\alias{lp}
\title{Linear predictors}
\usage{
lp(formula, coefs, data, ...)
}
\arguments{
\item{formula}{formula specifying the linear predictors.}

\item{coefs}{vector of regression coefficients.}

\item{data}{data frame containing the covariates used to construct the linear predictors.}

\item{...}{further arguments passed to other methods.}
}
\value{
a vector containing the linear predictors.
}
\description{
Function to construct linear predictors.
}
\examples{
library(rsurv)
library(dplyr)

n <- 100
coefs <- c(1, 0.7, 2.3)

simdata <- data.frame(
  age = rnorm(n),
  sex = sample(c("male", "female"), size = n, replace = TRUE)
) |>
  mutate(
    lp = lp(~age+sex, coefs)
  )
glimpse(simdata)

}
