% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/syntax_rules.r
\name{apply_queries}
\alias{apply_queries}
\title{Apply queries created with \link{tquery}}
\usage{
apply_queries(
  tokens,
  ...,
  as_chain = FALSE,
  block = NULL,
  check = FALSE,
  fill = TRUE,
  return_wide = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{tokens}{A tokenIndex data.table, or any data.frame coercible with \link{as_tokenindex}.}

\item{...}{tqueries, as created with \link{tquery}. Can also be a list with tquery functions. It is recommended to use named arguments/lists, to name the tqueries.}

\item{as_chain}{If TRUE, Nodes that have already been assigned assigned earlier in the chain will be ignored (see 'block' argument).}

\item{block}{Optionally, specify ids (doc_id - sentence - token_id triples) where find_nodes will stop (ignoring the id and recursive searches through the id). 
Can also be a data.table returned by (a previous) apply_queries, in which case all ids are blocked.}

\item{check}{If TRUE, return a warning if nodes occur in multiple patterns, which could indicate that the find_nodes query is not specific enough.}

\item{fill}{If TRUE (default) the fill nodes are added. Otherwise these are ignored, even if the queries include fill()}

\item{return_wide}{If TRUE, return nodes in wide format.}

\item{verbose}{If TRUE, report progress (only useful if multiple queries are used)}
}
\value{
A data.table in which each row is a node for which all conditions are satisfied, and each column is one of the linked nodes 
               (parents / children) with names as specified in the label argument.
}
\description{
Apply queries created with \link{tquery}
}
\examples{
## spacy tokens for: Mary loves John, and Mary was loved by John
tokens = tokens_spacy[tokens_spacy$doc_id == 'text3',]

## two simple example tqueries
passive = tquery(pos = "VERB*", label = "predicate",
                 children(relation = c("agent"), label = "subject"))
active =  tquery(pos = "VERB*", label = "predicate",
                 children(relation = c("nsubj", "nsubjpass"), label = "subject"))

nodes = apply_queries(tokens, pas=passive, act=active)
nodes
}
