% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_toString.R
\name{matrix_form,VTableTree-method}
\alias{matrix_form,VTableTree-method}
\title{Transform an \code{rtable} to a list of matrices which can be used for outputting}
\usage{
\S4method{matrix_form}{VTableTree}(
  obj,
  indent_rownames = FALSE,
  expand_newlines = TRUE,
  indent_size = 2,
  fontspec = NULL,
  col_gap = 3L,
  round_type = c("iec", "sas")
)
}
\arguments{
\item{obj}{(\code{ANY})\cr the object for the accessor to access or modify.}

\item{indent_rownames}{(\code{flag})\cr if \code{TRUE}, the column with the row names in the \code{strings} matrix of the output
has indented row names (strings pre-fixed).}

\item{expand_newlines}{(\code{flag})\cr whether the matrix form generated should expand rows whose values contain
newlines into multiple 'physical' rows (as they will appear when rendered into ASCII). Defaults to \code{TRUE}.}

\item{indent_size}{(\code{numeric(1)})\cr number of spaces to use per indent level. Defaults to 2.}

\item{fontspec}{(\code{font_spec})\cr The font that should be used by default when
rendering this \code{MatrixPrintForm} object, or NULL (the default).}

\item{col_gap}{(\code{numeric(1)})]\cr The number of spaces (in the font specified
by \code{fontspec}) that should be placed between columns when the table
is rendered directly to text (e.g., by \code{toString} or \code{export_as_txt}). Defaults
to \code{3}.}

\item{round_type}{(\code{"iec"} or \code{"sas"})\cr the type of rounding to perform. iec,
the default, peforms rounding compliant with IEC 60559 (see details), while
sas performs nearest-value rounding consistent with rounding within SAS.}
}
\value{
A list with the following elements:
\describe{
\item{\code{strings}}{The content, as it should be printed, of the top-left material, column headers, row labels,
and cell values of \code{tt}.}
\item{\code{spans}}{The column-span information for each print-string in the \code{strings} matrix.}
\item{\code{aligns}}{The text alignment for each print-string in the \code{strings} matrix.}
\item{\code{display}}{Whether each print-string in the strings matrix should be printed.}
\item{\code{row_info}}{The \code{data.frame} generated by \code{make_row_df}.}
}

With an additional \code{nrow_header} attribute indicating the number of pseudo "rows" that the column structure defines.
}
\description{
Although \code{rtables} are represented as a tree data structure when outputting the table to ASCII or HTML
it is useful to map the \code{rtable} to an in-between state with the formatted cells in a matrix form.
}
\details{
The strings in the return object are defined as follows: row labels are those determined by \code{make_row_df} and cell
values are determined using \code{get_formatted_cells}. (Column labels are calculated using a non-exported internal
function.
}
\examples{
\dontshow{if (require(dplyr)) withAutoprint(\{ # examplesIf}
library(dplyr)

iris2 <- iris \%>\%
  group_by(Species) \%>\%
  mutate(group = as.factor(rep_len(c("a", "b"), length.out = n()))) \%>\%
  ungroup()

lyt <- basic_table() \%>\%
  split_cols_by("Species") \%>\%
  split_cols_by("group") \%>\%
  analyze(c("Sepal.Length", "Petal.Width"),
    afun = list_wrap_x(summary), format = "xx.xx"
  )

lyt

tbl <- build_table(lyt, iris2)

matrix_form(tbl)
\dontshow{\}) # examplesIf}
}
