% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colours.R
\name{rtist_palette}
\alias{rtist_palette}
\title{Artist and painting palette generator}
\usage{
rtist_palette(artist, n)
}
\arguments{
\item{artist}{Name of desired artist palette. Choices are:
\code{raphael}, \code{hokusai}, \code{vermeer}, \code{degas}, \code{davinci}, \code{vangogh}, \code{hopper}, \code{klimt}, \code{rembrandt}, \code{munch}, \code{okeeffe}, \code{warhol}, \code{oldenburg}, \code{picasso}, \code{pollock}}

\item{n}{Number of colors desired. All palettes have 5 colors. Most color schemes are derived from \href{http://www.skellermeyerdesigns.com/blog/10-color-palettes-based-on-famous-paintings}{10 Color Palettes Based on Famous Paintings}. If omitted, will use all colors.}
}
\value{
A vector of colors.
}
\description{
Pick an artist name and number of colors desired.
}
\examples{
rtist_palette("warhol")
rtist_palette("pollock", 4)
}
\keyword{art}
\keyword{color}
\keyword{colors}
\keyword{colour}
\keyword{colours}
\keyword{palette}
