% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_post.R
\name{totals}
\alias{totals}
\title{Extract time-totals from TRIM output}
\usage{
totals(
  x,
  which = c("imputed", "fitted", "both"),
  obs = FALSE,
  level = NULL,
  long = FALSE
)
}
\arguments{
\item{x}{TRIM output structure (i.e., output of a call to \code{trim})}

\item{which}{(character) Select what totals to compute (see \code{Details} section).}

\item{obs}{(logical) Flag to include total observations (or not).}

\item{level}{(numeric) The confidence level required. If NULL, no confidence intervals are calculated.}

\item{long}{(logical) Flag to return a tidy long table}
}
\value{
A \code{data.frame} with subclass \code{trim.totals}
 (for pretty-printing). The columns are \code{time}, \code{fitted}
 and \code{se_fit} (for standard error), and/or \code{imputed}
 and \code{se_imp}, depending on the selection.\cr
 In case \code{long=TRUE} a long table is returned, and a different naming convention is used,
 e.g., imputed/fitted info is in column \code{series},
 and standard error are always in column \code{SE}
}
\description{
Extract time-totals from TRIM output
}
\section{Details}{


The idea of \code{TRIM} is to impute those site-time combinations where
no counts are available. Time-totals (i.e. summed over sites) can be obtained
for two cases:

\itemize{
\item{\code{"imputed"}: Time totals are computed after replacing missing values with values predicted by the model}.
\item{\code{"fitted"}: Time totals are computed after replacing both missing values and observed values with
values predicted by the model.}
}
}

\examples{
data(skylark)
z <- trim(count ~ site + time, data=skylark, model=2, changepoints=c(3,5))
totals(z)

totals(z, "both") # mimics classic TRIM

}
\seealso{
Other analyses: 
\code{\link{coef.trim}()},
\code{\link{confint.trim}()},
\code{\link{gof}()},
\code{\link{index}()},
\code{\link{now_what}()},
\code{\link{overall}()},
\code{\link{overdispersion}()},
\code{\link{plot.trim.index}()},
\code{\link{plot.trim.overall}()},
\code{\link{plot.trim.smooth}()},
\code{\link{results}()},
\code{\link{serial_correlation}()},
\code{\link{summary.trim}()},
\code{\link{trendlines}()},
\code{\link{trim}()},
\code{\link{vcov.trim}()},
\code{\link{wald}()}
}
\concept{analyses}
