% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findabsorptionfeatures.R
\name{findabsorptionfeatures}
\alias{findabsorptionfeatures}
\title{Find Absorption Features in a Spectrum}
\usage{
findabsorptionfeatures(
  wvl,
  flux,
  pix_range = 7,
  gamma = 0.01,
  alpha = 0.05,
  minlinedepth = 0,
  cores = 1
)
}
\arguments{
\item{wvl}{vector of wavelengths in the spectrum}

\item{flux}{vector of normalized flux in the spectrum (must have the same length as \code{wvl})}

\item{pix_range}{integer that specifies the window size in units of pixels to use in the moving linear regression}

\item{gamma}{significance level used in finding local minima}

\item{alpha}{significance level used in estimating wavelength bounds of features (\strong{Note:} this must be larger than \code{gamma})}

\item{minlinedepth}{minimum depth required for found absorption features to be returned}

\item{cores}{number of cores to parallelize over (if set to 1, no parallelizing is done)}
}
\value{
a list with the following components:
\item{wvbounds}{a list of length 2 vectors that each give the lower and upper bounds of found absorption features}
\item{min_wvl}{a vector of the wavelengths at which the minimum flux is achieved for each found absorption feature}
\item{min_flx}{a vector of the minimum flux for each found absorption feature}
\item{max_flx}{a vector of the maximum flux for each found absorption feature}
}
\description{
This function applies the Absorption Feature Finder algorithm (Algorithm 1 in
\href{https://arxiv.org/abs/2005.14083}{Holzer et. al 2020}) to find absorption 
features in a high signal-to-noise,
normalized, spectrum. For a spectrum that covers more than 100 Angstroms, it is
recommended to parallelize it by setting the \code{cores} argument to be greater
than 1.
}
\examples{
data(template)
ftrs = findabsorptionfeatures(template$Wavelength,
                              template$Flux,
                              pix_range = 8, gamma = 0.05,
                              alpha = 0.07, minlinedepth = 0.015)
plot(template$Wavelength, template$Flux,
     type='l', xlab = "Wavelength", ylab = "Flux")
for(i in 1:length(ftrs$wvbounds)){
  lines(ftrs$wvbounds[[i]],
        c(1,1) - 0.01*rep(i\%\%2,2), col=3)
}
}
