% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IWT2_PO.R
\name{IWT2_PO}
\alias{IWT2_PO}
\title{Inverse 2-d MRA Wavelet Transform (periodized, orthogonal)}
\usage{
IWT2_PO(wc, L, qmf)
}
\arguments{
\item{wc}{2-d wavelet transform (n by n array, n dyadic).}

\item{L}{coarse level.}

\item{qmf}{quadrature mirror filter.}
}
\value{
\code{x} 2-d signal reconstructed from wc.
}
\description{
If \code{wc} is the result of a forward 2d wavelet transform, with \code{wc <- FWT2_PO(x,L,qmf)}.
then \code{x <- IWT2_PO(wc,L,qmf)} reconstructs \code{x} exactly
\code{qmf} is a nice qmf, e.g. one made by \code{\link{MakeONFilter}}.
}
\examples{
qmf <- MakeONFilter('Daubechies', 10)
L <- 3
x <- matrix(rnorm(128^2),ncol=128)
wc <- FWT2_PO(x, L, qmf)
xr <- IWT2_PO(wc,L,qmf)
}
\seealso{
\code{\link{FWT2_PO}}, \code{\link{MakeONFilter}}.
}
