% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{countryRegions}
\alias{countryRegions}
\title{Regional Classification Table}
\format{
A data frame with the following variables.  \describe{
\item{ISO3}{ISO 3 letter country code} \item{ADMIN}{country
name} \item{REGION}{7 region continent classification}
\item{continent}{6 continents classification}
\item{GEO3major}{Global Environment Outlook GEO3 major region names}
\item{GEO3}{Global Environment Outlook GEO3 major region names}
\item{IMAGE24}{Image24 region names} \item{GLOCAF}{GLOCAF
region names} \item{Stern}{Stern report region names}
\item{SRESmajor}{SRES major region names} \item{SRES}{SRES
region names} \item{GBD}{Global Burden of Disease GBD region names}
\item{AVOIDnumeric}{numeric codes for AVOID regions}
\item{AVOIDname}{AVOID regions} \item{LDC}{UN Least
Developed Countries} \item{SID}{UN Small Island Developing states}
\item{LLDC}{UN Landlocked Developing Countries} }
}
\description{
A number of regional classifications exist, e.g. SRES, Stern, etc. This
table can be used to find which grouping a country belongs to, given its
country code. A variety of different codes or groupings can be used.
}
\details{
Joined onto vector country maps. Used by \code{\link{country2Region}} and
\code{\link{mapByRegion}}.
}
\examples{

data(countryRegions,envir=environment(),package="rworldmap")
str(countryRegions)

#joining example data onto the regional classifications
data(countryExData,envir=environment(),package="rworldmap")
dF <- merge(countryExData,countryRegions,by.x='ISO3V10',by.y='ISO3')
#plotting ENVHEALTH for Least Developed Countries (LDC) against others
#plot( dF$ENVHEALTH ~ dF$LDC)
#points( y=dF$ENVHEALTH, x=dF$LDC)


}
\keyword{datasets}
