% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSC.R
\name{MSC}
\alias{MSC}
\title{Multi-Level Spectral Clustering}
\usage{
MSC(
  X,
  levelMax,
  silMin = 0.7,
  vois = 7,
  flagDiagZero = FALSE,
  method = "default",
  Kmax = 20,
  tolerence = 0.99,
  threshold = 0.7,
  minPoint = 7,
  verbose = FALSE
)
}
\arguments{
\item{X}{The dataFrame.}

\item{levelMax}{The maximum depth level.}

\item{silMin}{The minimal silhouette allowed. Below this value, the cluster will be cut again.}

\item{vois}{number of points that will be selected for the similarity computation.}

\item{flagDiagZero}{if True, Put zero on the similarity matrix W.}

\item{method}{The method that will be used. "default" to let the function choose the most suitable method. "PEV" for the Principal EigenValue method. "GAP" for the GAP method.}

\item{Kmax}{The maximum number of cluster which is allowed.}

\item{tolerence}{The tolerance allowed for the Principal EigenValue method.}

\item{threshold}{The threshold to select the dominant eigenvalue for the GAP method.}

\item{minPoint}{The minimum number of points required to compute a cluster.}

\item{verbose}{To output the verbose in the terminal.}
}
\value{
returns a list containing the following elements:
\itemize{
 \item{cluster: }{a vector containing the cluster}
 \item{eigenVect: }{a vector containing the eigenvectors}
 \item{eigenVal: }{a vector containing the eigenvalues}
}
}
\description{
The function, for a given dataFrame, will separate the data using the NJW clustering in several levels.
}
\examples{
### Example 1: 2 disks of the same size
n<-100 ; r1<-1
x<-(runif(n)-0.5)*2;
y<-(runif(n)-0.5)*2
keep1<-which((x*2+y*2)<(r1*2))
disk1<-data.frame(x+3*r1,y)[keep1,]
disk2 <-data.frame(x-3*r1,y)[keep1,]
sameTwoDisks <- rbind(disk1,disk2)
res <- MSC(scale(sameTwoDisks),levelMax=5, silMin=0.7, vois=7, 
           flagDiagZero=TRUE, method = "default", Kmax = 20, 
           tolerence = 0.99,threshold = 0.7, minPoint = 7, verbose = TRUE)
plot(sameTwoDisks, col = as.factor(res[,ncol(res)]))

### Example 2: Speed and Stopping Distances of Cars
res <- MSC(scale(iris[,-5]),levelMax=5, silMin=0.7, vois=7, 
           flagDiagZero=TRUE, method = "default", Kmax = 20, 
           tolerence = 0.99,threshold = 0.9, minPoint = 7, verbose = TRUE)
plot(iris, col = as.factor(res[,ncol(res)]))
table(res[,ncol(res)],iris$Species)
}
\references{
Grassi, K. (2020) Definition multivariee et multi-echelle d'etats environnementaux par Machine Learning : Caracterisation de la dynamique phytoplanctonique.
}
\author{
Emilie Poisson Caillault and Erwan Vincent
}
