\name{snp.refine.boundary}
\alias{snp.refine.boundary}
\title{
Refine Segment Boundaries
}
\description{
Refine the segment boundaries based on the grid of heterozygous probes 
by all probes with LRR data. We do not recommend to perform this step 
except in the case that the segment boundaries need to be aligned well 
on the same grid of probes for downstream analysis.
}
\usage{
snp.refine.boundary(data, segs.stat)
}
\arguments{
  \item{data}{a data frame containing log2ratio and log2mBAF data generated 
  	by \code{\link{snp.cnv.data}}.
}
  \item{segs.stat}{a data frame containing segment locations and summary statistics 
  	resulting from \code{\link{cnv.call}}.
}
}
%% \details{
%%  ~~ If necessary, more details than the description above ~~
%% }
\value{
A data frame with the same columns as the one generated by 
\code{\link{cnv.call}} with the columns \code{posStart}, 
\code{posEnd}, \code{length}, \code{chrIdxStart}, 
\code{chrIdxEnd} and \code{numProbe} updated accordingly.
}
%% \references{
%% ~put references to the literature/web site here ~
%% }
\author{
Zhongyang Zhang <zhongyang.zhang@mssm.edu>
}
%% \note{
%%  ~~further notes~~
%% }
\seealso{
\code{\link{snp.cnv.data}}, \code{\link{cnv.call}}
}
\examples{
\dontrun{
## download snp.data.RData
url <- "https://zhangz05.u.hpc.mssm.edu/saasCNV/data/snp.data.RData"
tryCatch({download.file(url=url, destfile="snp.data.RData")
         }, error = function(e) {
          download.file(url=url, destfile="snp.data.RData", method="curl")
         })
## If download.file fails to download the data, please manually download it from the url.

load("snp.data.RData")
data(snp.cnv)
snp.cnv.refine <- snp.refine.boundary(data=snp.data, segs.stat=snp.cnv)
}

## how the results look like
data(snp.cnv.refine)
head(snp.cnv.refine)
}
\keyword{ CNV }
\keyword{ SNP array }
