% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prodnormal.r
\name{prodnormal}
\alias{prodnormal}
\alias{dprodnormal}
\alias{pprodnormal}
\alias{qprodnormal}
\alias{rprodnormal}
\title{The product of normal random variates.}
\usage{
dprodnormal(x, mu, sigma, log = FALSE, order.max=5)

pprodnormal(q, mu, sigma, lower.tail = TRUE, log.p = FALSE, order.max=5)

qprodnormal(p, mu, sigma, lower.tail = TRUE, log.p = FALSE, order.max=5)

rprodnormal(n, mu, sigma)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{the vector of means.
This is recycled against the \code{sigma}, but not against the \code{x,q,p,n}.}

\item{sigma}{the vector of standard deviations.
This is recycled against the \code{mu}, but not against the \code{x,q,p,n}.}

\item{log}{logical; if TRUE, densities \eqn{f} are given 
as \eqn{\mbox{log}(f)}{log(f)}.}

\item{order.max}{the order to use in the approximate density,
distribution, and quantile computations, via the Gram-Charlier,
Edeworth, or Cornish-Fisher expansion.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{log.p}{logical; if TRUE, probabilities p are given 
as \eqn{\mbox{log}(p)}{log(p)}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P[X \le x]}{P[X <= x]}, otherwise, \eqn{P[X > x]}{P[X > x]}.}
}
\value{
\code{dprodnormal} gives the density, \code{pprodnormal} gives the 
distribution function, \code{qprodnormal} gives the quantile function, 
and \code{rprodnormal} generates random deviates.

Invalid arguments will result in return value \code{NaN} with a warning.
}
\description{
Density, distribution function, quantile function and random
generation for the distribution of the product of indepdendent
normal random variables.
}
\details{
Let \eqn{Z_i \sim \mathcal{N}\left(\mu_i, \sigma_i^2\right)}{Z_i ~ N(mu_i, sigma_i^2)}
be independently distributed normal variates, with means \eqn{\mu_i}{mu_i}
and variances \eqn{\sigma_i^2}{sigma_i^2}.
Suppose \deqn{Y = \prod_i Z_i.}{Z = prod (Z_i).}
Then \eqn{Y}{Y} follows a product of normals distribution.
}
\note{
The PDF, CDF, and quantile function are approximated, via
the Edgeworth or Cornish Fisher approximations, which may
not be terribly accurate in the tails of the distribution.
You are warned.

The distribution parameters are \emph{not} recycled
with respect to the \code{x, p, q} or \code{n} parameters,
for, respectively, the density, distribution, quantile
and generation functions. This is for simplicity of
implementation and performance. It is, however, in contrast
to the usual R idiom for dpqr functions.
}
\examples{
mu <- c(100,20,10)
sigma <- c(10,50,10)
rvs <- rprodnormal(128, mu, sigma)
dvs <- dprodnormal(rvs, mu, sigma)
qvs <- pprodnormal(rvs, mu, sigma)
pvs <- qprodnormal(ppoints(length(rvs)), mu, sigma)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{distribution}
