% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hb_unit.R
\name{hb_unit}
\alias{hb_unit}
\title{Basic Unit Level Model (Battese-Harter-Fuller model) using Hierarchical Bayesian Approach}
\usage{
hb_unit(
  formula,
  data_unit,
  data_area,
  domain,
  iter.update = 3,
  iter.mcmc = 10000,
  coef,
  var.coef,
  thin = 3,
  burn.in = 2000,
  tau.u = 1,
  seed = 1,
  quiet = TRUE,
  plot = TRUE
)
}
\arguments{
\item{formula}{an object of class formula that contains a description of the model to be fitted. The variables included in the formula must be contained in the data.}

\item{data_unit}{data frame containing the variables named in \code{formula} and \code{domain}.}

\item{data_area}{data frame containing the variables named in \code{formula} and \code{domain}. Each remaining column contains the population means of each of the p auxiliary variables for the D domains.}

\item{domain}{Character or formula for domain column names in unit data \code{data_unit} and area data \code{data_area}. (example : "County" or ~County)}

\item{iter.update}{Number of updates with default 3}

\item{iter.mcmc}{Number of total iterations per chain with default 10000}

\item{coef}{a vector contains prior initial value of Coefficient of Regression Model for fixed effect with default vector of 0 with the length of the number of regression coefficients}

\item{var.coef}{a vector contains prior initial value of variance of Coefficient of Regression Model with default vector of 1 with the length of the number of regression coefficients}

\item{thin}{Thinning rate, must be a positive integer with default 2}

\item{burn.in}{Number of iterations to discard at the beginning with default 2000}

\item{tau.u}{Prior initial value of inverse of Variance of area random effect with default 1}

\item{seed}{number used to initialize a pseudorandom number generator (default seed = 1). The random number generator method used is "base::Wichmann-Hill".}

\item{quiet}{if TRUE, then messages generated during compilation will be suppressed (default TRUE).}

\item{plot}{if TRUE, the autocorrelation, trace, and density plots will be generated (default TRUE).}
}
\value{
The function returns a list with the following objects : Estimation \code{Est}, random effect variance \code{refVar}, beta coefficient \code{Coefficient} and MCMC result \code{result_mcmc}
}
\description{
This function gives the Hierarchical Bayesian (HB) based on a basic unit level model (Battese-Harter-Fuller model).
}
\examples{
library(dplyr)

Xarea <- cornsoybeanmeans \%>\%
   dplyr::select(
      County = CountyIndex,
      CornPix = MeanCornPixPerSeg,
      SoyBeansPix = MeanSoyBeansPixPerSeg
   )

corn_model <- hb_unit(
   CornHec ~ SoyBeansPix + CornPix,
   data_unit = cornsoybean,
   data_area = Xarea,
   domain = "County",
   iter.update = 20
)

}
\references{
\enumerate{
 \item Battese, G. E., Harter, R. M., & Fuller, W. A. (1988). An error-components model for prediction of county crop areas using survey and satellite data. Journal of the American Statistical Association, 83(401), 28-36.
 \item Rao, J. N., & Molina, I. (2015). Small area estimation. John Wiley & Sons.
}
}
