% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackknifeEB.R
\name{jackknifeEB}
\alias{jackknifeEB}
\title{Small Area Estimation method with Empirical Bayes and its RRMSE value by Jackknife Method}
\usage{
jackknifeEB(data, method, opt, maxiter = 100, tol = 1e-05)
}
\arguments{
\item{data}{the data must contain two or three columns : code, y, and weight data if exist.}

\item{method}{Method to estimate alpha and beta parameter according to person(rao or claire)}

\item{opt}{Method to estimate alpha and beta parameter according to the way of calculation (moment or nr)}

\item{maxiter}{the Maximum iteration value with default 100}

\item{tol}{Tolerance error value at iteration with default 0.00001}
}
\value{
This function returns a list with following objects :
\item{finalres}{an information about direct estimator and EB estimator in each area with its RRMSE value obtained by jackknife method}
\item{eb.estimation}{an information about EB estimator in each area with its RRMSE value obtained by Naive method}
}
\description{
Small Area Estimation method with Empirical Bayes and its RRMSE value by Jackknife Method
}
\examples{
## load dataset with no weight value
data(dataEB)
## Calculates EB estimator with
## its RRMSE value by Jackknife method.
## Its alpha and beta estimator obtained
## by Moment method by J.N.K.Rao
jackknifeEB(data = dataEB[,-c(3)], method = "rao",
 opt = "moment", maxiter = 20, tol = 1e-5)

##load dataset with weight value
data(dataEB)
## Calculates EB estimator with
## its RRMSE value by Jackknife method.
## Its alpha and beta estimator obtained
## by Moment method by Claire E.B.O.
jackknifeEB(data = dataEB, method = "rao",
 opt = "moment", maxiter = 20, tol = 1e-5)

}
