% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vectorClaire.R
\name{vectorClaire}
\alias{vectorClaire}
\title{Vector g in Newton Raphson Method by Claire E.B.O.}
\usage{
vectorClaire(alpha, beta, p)
}
\arguments{
\item{alpha}{An alpha estimate value on iterating process}

\item{beta}{A beta estimate value on iterating process}

\item{p}{direct estimator or proportion value}
}
\value{
This function returns a value of vector g.
}
\description{
Vector g in Newton Raphson Method by Claire E.B.O.
}
\examples{
## load dataset with no weight value
data(dataEB)
temp = pcapdir(dataEB[,-c(3)])

## estimates alpha and beta parameter
## in EB estimate with Moment method by J.N.K.Rao
temp1 = alphabetaEB(data.dir = temp$direst ,pcap = temp$pcap,
                      method = "rao", opt = "moment",
                      maxiter = 100,tol = 0.00001)

##calculates vector g
vectorClaire(alpha = temp1$alpha_cap, beta = temp1$beta_cap, p = temp$direst$p)

}
