% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tags.R
\name{tags}
\alias{tags}
\title{Get the list of tags in a safeframe}
\usage{
tags(x, show_null = FALSE)
}
\arguments{
\item{x}{a \code{safeframe} object}

\item{show_null}{DEPRECATED}
}
\value{
The function returns a named \code{list} where names indicate generic
types of data, and values indicate which column they correspond to.
}
\description{
This function returns the list of tags identifying specific variable types
in a \code{safeframe} object.
}
\details{
tags are stored as the \code{label} attribute of the column variable.
}
\examples{

## make a safeframe
x <- make_safeframe(cars, mph = "speed")

## check non-null tags
tags(x)

## get a list of all tags, including NULL ones
tags(x, TRUE)
}
