% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logRankTest.R
\name{computeLogrankNEvents}
\alias{computeLogrankNEvents}
\title{Helper function: Computes the planned sample size based on the minimal clinical relevant hazard ratio,
alpha and beta under optional stopping.}
\usage{
computeLogrankNEvents(
  hrMin,
  beta,
  m0 = 50000,
  m1 = 50000,
  alpha = 0.05,
  alternative = c("twoSided", "greater", "less"),
  nSim = 1000L,
  nBoot = 1000L,
  groupSizePerTimeFunction = returnOne,
  nMax = Inf,
  parameter = NULL,
  digits = getOption("digits"),
  pb = TRUE
)
}
\arguments{
\item{hrMin}{numeric that defines the minimal relevant hazard ratio, the smallest hazard ratio that we want to
detect.}

\item{beta}{numeric in (0, 1) that specifies the tolerable type II error control necessary to calculate both "n"
and "phiS". Note that 1-beta defines the power.}

\item{m0}{Number of subjects in the control group 0/1 at the beginning of the trial, i.e., nPlan[1].}

\item{m1}{Number of subjects in the treatment group 1/2 at the beginning of the trial, i.e., nPlan[2].}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{alternative}{a character string specifying the alternative hypothesis, which must be one of
"twoSided" (default),"greater" or "less". The alternative is pitted against the null hypothesis of equality
of the survival distributions. More specifically, let lambda1 be the hazard rate of group 1 (i.e., placebo), and
lambda2 the hazard ratio of group 2 (i.e., treatment), then the null hypothesis states that the hazard ratio
theta = lambda2/lambda1 = 1. If alternative = "less", the null hypothesis is compared to theta < 1, thus,
lambda2 < lambda1, that is, the hazard of group 2 (i.e., treatment) is less than that of group 1 (i.e., placebo),
hence, the treatment is beneficial. If alternative = "greater", then the null hypothesis is compared to theta > 1,
thus, lambda2 > lambda1, hence, harm.}

\item{nSim}{integer > 0, the number of simulations needed to compute power or the number of events for the exact
safe logrank test under continuous monitoring}

\item{nBoot}{integer > 0 representing the number of bootstrap samples to assess the accuracy of the approximation of
power or nEvents for the exact safe logrank test under continuous monitoring}

\item{groupSizePerTimeFunction}{A function without parameters and integer output. This function provides the number
of events at each time step. For instance, if \code{rpois(1, 7)} leads to a random number of events at each time
step.}

\item{nMax}{An integer. Once nEvents hits nMax the experiment terminates, if it didn't stop due to threshold
crossing crossing already. Default set to Inf.}

\item{parameter}{Numeric > 0, represents the safe tests defining thetaS. Default NULL so it's decided by the
algorithm, typically, this equals hrMin, which corresponds to the GROW choice.}

\item{digits}{number of significant digits to be used.}

\item{pb}{logical, if \code{TRUE}, then show progress bar.}
}
\value{
a list which contains at least nEvents and an adapted bootObject of class  \code{\link[boot]{boot}}.
}
\description{
Helper function: Computes the planned sample size based on the minimal clinical relevant hazard ratio,
alpha and beta under optional stopping.
}
\examples{
computeLogrankNEvents(0.7, 0.2, nSim=10)
}
\author{
Muriel Felipe Perez-Ortiz and Alexander Ly
}
