% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm.R
\name{PNI50}
\alias{PNI50}
\alias{PNI80}
\alias{WILD50}
\alias{SMSY85}
\alias{Sgen100}
\title{Example performance metrics}
\usage{
PNI50(SMSE, Ref = 0.5, Yrs = NULL)

PNI80(SMSE, Ref = 0.8, Yrs = NULL)

WILD50(SMSE, Ref = 0.5, Yrs = NULL)

SMSY85(SMSE, Ref = 0.85, Yrs = NULL)

Sgen100(SMSE, Ref = 1, Yrs = NULL)
}
\arguments{
\item{SMSE}{SMSE object returned by \code{\link[=salmonMSE]{salmonMSE()}}}

\item{Ref}{Threshold for the performance metric, used to calculate the probability that the metric exceeds this value}

\item{Yrs}{Numeric vector of length 2 to indicate the year range over which to summarize performance.
If NULL, the performance is summarized over all projection years.}
}
\value{
A vector of probabilities corresponding to population
}
\description{
Functions that evaluate return probabilities of outcomes from the simulations.
}
\details{
\itemize{
\item \code{PNI50} calculates the probability that PNI exceeds 0.50 (threshold for an integrated-transition population, Withler et al. 2018)
\item \code{PNI80} calculates the probability that PNI exceeds 0.80 (threshold for an integrated-wild population, Withler et al. 2018)
\item \code{WILD50} calculates the probability that at least 50 percent of natural spawners are wild
\item \code{SMSY85} calculates the probability that NOS/SMSY exceeds 0.85
\item \code{Sgen100} calculates the probability that NOS/Sgen exceeds 1
}
}
\references{
Withler et al. 2018. Genetically Based Targets for Enhanced Contributions to Canadian Pacific Chinook Salmon Populations.
DFO Can. Sci. Advis. Sec. Res. Doc. 2018/019. xii + 88 p.
}
