% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRR.R
\name{calc_SRR}
\alias{calc_SRR}
\title{Calculate abundance from density-dependent mortality}
\usage{
calc_SRR(N1, N2 = N1, p, capacity, type = c("BH", "Ricker", "HS"))
}
\arguments{
\item{N1}{Numeric, the initial abundance that scales the density-independent survival term}

\item{N2}{Numeric, the initial abundance that scales the density-dependent survival term}

\item{p}{Numeric, the productivity parameter that sets the maximum survival as the initial abundance approaches zero}

\item{capacity}{Numeric, the capacity parameter that set the maximum survivors}

\item{type}{Character, the functional form of the stock-recruit relationship}
}
\value{
Numeric, the abundance of survivors
}
\description{
Calculates the abundance of survivors after applying either a Beverton-Holt or Ricker stock-recruit relationship.
}
\details{
The Beverton-Holt stock recruit relationship is of the following form:
\deqn{\textrm{Smolt} = \dfrac{\alpha N_1}{1 + \beta N_2}}
where \eqn{\alpha = P}, \eqn{\beta = P/C}.

The Ricker stock recruit relationship is of the following form:
\deqn{\textrm{Smolt} = \alpha N_1 \exp(-\beta N_2)}
where \eqn{\alpha = P}, \eqn{\beta = P/(Ce)}, \eqn{e} is Euler's number.

Productivity \eqn{P} is in terms of abundance per unit of \eqn{N_1} and \eqn{N_2}.

The hockey stick is of the following form:

\deqn{
\textrm{Smolt} =
\begin{cases}
p N_1 &, N_1 \le \frac{N_1}{N_2} \times C\\
\frac{N_1}{N_2} \times C &, \textrm{otherwise}
\end{cases}
}
}
\seealso{
\code{\link[=calc_SRRpars]{calc_SRRpars()}}
}
