% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss4ddm.R
\name{ss4ddm}
\alias{ss4ddm}
\title{The required sample size for estimating a double difference of means}
\usage{
ss4ddm(
  N,
  mu1,
  mu2,
  mu3,
  mu4,
  sigma1,
  sigma2,
  sigma3,
  sigma4,
  DEFF = 1,
  conf = 0.95,
  cve = 0.05,
  rme = 0.03,
  T = 0,
  R = 1,
  plot = FALSE
)
}
\arguments{
\item{N}{The maximun population size between the groups (strata) that we want to compare.}

\item{mu1}{The value of the estimated mean of the variable of interes for the first population.}

\item{mu2}{The value of the estimated mean of the variable of interes for the second population.}

\item{mu3}{The value of the estimated mean of the variable of interes for the third population.}

\item{mu4}{The value of the estimated mean of the variable of interes for the fourth population.}

\item{sigma1}{The value of the estimated variance of the variable of interes for the first population.}

\item{sigma2}{The value of the estimated mean of a variable of interes for the second population.}

\item{sigma3}{The value of the estimated variance of the variable of interes for the third population.}

\item{sigma4}{The value of the estimated mean of a variable of interes for the fourth population.}

\item{DEFF}{The design effect of the sample design. By default \code{DEFF = 1}, which corresponds to a simple random sampling design.}

\item{conf}{The statistical confidence. By default conf = 0.95. By default \code{conf = 0.95}.}

\item{cve}{The maximun coeficient of variation that can be allowed for the estimation.}

\item{rme}{The maximun relative margin of error that can be allowed for the estimation.}

\item{T}{The overlap between waves. By default \code{T = 0}.}

\item{R}{The correlation between waves. By default \code{R = 1}.}

\item{plot}{Optionally plot the errors (cve and margin of error) against the sample size.}
}
\description{
This function returns the minimum sample size required for estimating a double difference of means subjecto to predefined errors.
}
\details{
Note that the minimun sample size to achieve a relative margin of error \eqn{\varepsilon} is defined by: 
\deqn{n = \frac{n_0}{1+\frac{n_0}{N}}}
Where \deqn{n_0=\frac{z^2_{1-\frac{alpha}{2}}S^2}{\varepsilon^2 \mu^2}} and 
\eqn{S^2=(\sigma_1^2 + \sigma_2^2 + \sigma_3^2 + \sigma_4^2) * (1 - (T * R)) * DEFF}
Also note that the minimun sample size to achieve a coefficient of variation \eqn{cve} is defined by:
\deqn{n = \frac{S^2}{|(\bar{y}_1-\bar{y}_2) - (\bar{y}_3-\bar{y}_4) |^2 cve^2 + \frac{S^2}{N}}}
}
\examples{
ss4ddm(N=100000, mu1=50, mu2=55, mu3=50, mu4=65, 
sigma1 = 10, sigma2 = 12, sigma3 = 10, sigma4 = 12, cve=0.05, rme=0.03)
ss4ddm(N=100000, mu1=50, mu2=55, mu3=50, mu4=65, 
sigma1 = 10, sigma2 = 12, sigma3 = 10, sigma4 = 12, cve=0.05, rme=0.03, plot=TRUE)
ss4ddm(N=100000, mu1=50, mu2=55, mu3=50, mu4=65, 
sigma1 = 10, sigma2 = 12, sigma3 = 10, sigma4 = 12, DEFF=3.45, conf=0.99, cve=0.03, 
     rme=0.03, plot=TRUE)

#############################
# Example with BigLucy data #
#############################
data(BigLucyT0T1)
attach(BigLucyT0T1)

BigLucyT0 <- BigLucyT0T1[Time == 0,]
BigLucyT1 <- BigLucyT0T1[Time == 1,]
N1 <- table(BigLucyT0$ISO)[1]
N2 <- table(BigLucyT0$ISO)[2]
N <- max(N1,N2)

BigLucyT0.yes <- subset(BigLucyT0, ISO == "yes")
BigLucyT0.no <- subset(BigLucyT0, ISO == "no")
BigLucyT1.yes <- subset(BigLucyT1, ISO == "yes")
BigLucyT1.no <- subset(BigLucyT1, ISO == "no")
mu1 <- mean(BigLucyT0.yes$Income)
mu2 <- mean(BigLucyT0.no$Income)
mu3 <- mean(BigLucyT1.yes$Income)
mu4 <- mean(BigLucyT1.no$Income)
sigma1 <- sd(BigLucyT0.yes$Income)
sigma2 <- sd(BigLucyT0.no$Income)
sigma3 <- sd(BigLucyT1.yes$Income)
sigma4 <- sd(BigLucyT1.no$Income)

# The minimum sample size for simple random sampling
ss4ddm(N, mu1, mu2, mu3, mu4, sigma1, sigma2, sigma3, sigma4, 
DEFF=1, conf=0.95, cve=0.001, rme=0.001, plot=TRUE)
# The minimum sample size for a complex sampling design
ss4ddm(N, mu1, mu2, mu3, mu4, sigma1, sigma2, sigma3, sigma4, 
DEFF=3.45, conf=0.99, cve=0.03, rme=0.03, plot=TRUE)
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{e4p}}
}
\author{
Hugo Andres Gutierrez Rojas <hagutierrezro at gmail.com>
}
