% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Z_identities.R
\name{Z_identities}
\alias{Z_identities}
\title{Z Identities}
\usage{
Z_identities(
  a = NULL,
  b = NULL,
  a_and_b = NULL,
  a_or_b = NULL,
  a_given_b = NULL,
  b_given_a = NULL,
  a_given_not_b = NULL,
  b_given_not_a = NULL,
  a_and_not_b = NULL,
  b_and_not_a = NULL,
  not_a = NULL,
  not_b = NULL
)
}
\arguments{
\item{a, b, a_and_b, a_or_b, a_given_b, b_given_a, a_given_not_b, b_given_not_a, a_and_not_b, b_and_not_a}{Probability estimates given by participants}

\item{not_a, not_b}{Probability estimates given by participants. If not given, they'll default to 1-a and 1-b respectively}
}
\value{
Dataframe with identities Z1 to Z18
}
\description{
Calculates identities Z1 to Z18 as defined in \insertCite{costello2016PeopleConditionalProbability,zhu2020BayesianSamplerGeneric}{samplr}. Probability theory predicts that these will all equal 0.
}
\details{
If some of the probability estimates are not given, calculation will proceed and equalities that cannot be calculated will be coded as NA.
}
\examples{
Z_identities(
 a=.5, 
 b=.1, 
 a_and_b=.05, 
 a_or_b=.55, 
 a_given_b=.5,
 b_given_a=.1,
 a_given_not_b=.5,
 b_given_not_a=.1,
 a_and_not_b=.45,
 b_and_not_a=.05,
 )
#Get identities for a set of participants
library(magrittr)
library(dplyr)
library(tidyr)
data.frame(
 ID = LETTERS[1:20],
 a=runif(20),
 b=runif(20),
 a_and_b=runif(20),
 a_or_b=runif(20),
 a_given_b=runif(20),
 b_given_a=runif(20),
 a_given_not_b=runif(20),
 b_given_not_a=runif(20),
 a_and_not_b=runif(20),
 b_and_not_a=runif(20),
 not_a=runif(20),
 not_b=runif(20)
) \%>\% 
 group_by(ID) \%>\% 
 do(
   Z_identities(
     .$a,
     .$b,
     .$a_and_b,
     .$a_or_b,
     .$a_given_b,
     .$b_given_a,
     .$a_given_not_b,
     .$b_given_not_a,
     .$a_and_not_b,
     .$b_and_not_a,
     .$not_a,
     .$not_b
   )
 )
}
\references{
\insertAllCited{}
}
