% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatMRHLP.R
\docType{class}
\name{StatMRHLP-class}
\alias{StatMRHLP-class}
\alias{StatMRHLP}
\title{A Reference Class which contains statistics of a MRHLP model.}
\description{
StatMRHLP contains all the statistics associated to a \link[=ParamMRHLP]{MRHLP}
model. It mainly includes the E-Step of the EM algorithm calculating the
posterior distribution of the hidden variables, as well as the calculation of
the log-likelhood at each step of the algorithm and the obtained values of
model selection criteria..
}
\section{Fields}{

\describe{
\item{\code{pi_ik}}{Matrix of size \eqn{(m, K)} representing the prior/logistic
probabilities \eqn{\pi_{k}(x_{i}; \boldsymbol{\Psi}) = P(z_{i} = k |
  \boldsymbol{x}; \Psi)}{\pi_{k}(x_{i}; \Psi) = P(z_{i} = k | x; \Psi)} of
the latent variable \eqn{z_{i}, i = 1,\dots,m}.}

\item{\code{z_ik}}{Hard segmentation logical matrix of dimension \eqn{(m, K)}
obtained by the Maximum a posteriori (MAP) rule: \eqn{z\_ik = 1 \
  \textrm{if} \ z\_ik = \textrm{arg} \ \textrm{max}_{s} \ \pi_{s}(x_{i};
  \boldsymbol{\Psi});\ 0 \ \textrm{otherwise}}{z_ik = 1 if z_ik = arg max_s
  \pi_{s}(x_{i}; \Psi); 0 otherwise}, \eqn{k = 1,\dots,K}.}

\item{\code{klas}}{Column matrix of the labels issued from \code{z_ik}. Its elements are
\eqn{klas(i) = k}, \eqn{k = 1,\dots,K}.}

\item{\code{tau_ik}}{Matrix of size \eqn{(m, K)} giving the posterior probability
that the observation \eqn{Y_{i}} originates from the \eqn{k}-th regression
model.}

\item{\code{polynomials}}{Array of size \eqn{(m, d, K)} giving the values of the
estimated polynomial regression components.}

\item{\code{weighted_polynomials}}{Array of size \eqn{(m, d, K)} giving the values
of the estimated polynomial regression components weighted by the prior
probabilities \code{pi_ik}.}

\item{\code{Ex}}{Matrix of size \emph{(m, d)}. \code{Ex} is the curve expectation
(estimated signal): sum of the polynomial components weighted by the
logistic probabilities \code{pi_ik}.}

\item{\code{loglik}}{Numeric. Observed-data log-likelihood of the MRHLP model.}

\item{\code{com_loglik}}{Numeric. Complete-data log-likelihood of the MRHLP model.}

\item{\code{stored_loglik}}{Numeric vector. Stored values of the log-likelihood at
each EM iteration.}

\item{\code{stored_com_loglik}}{Numeric vector. Stored values of the Complete
log-likelihood at each EM iteration.}

\item{\code{BIC}}{Numeric. Value of BIC (Bayesian Information Criterion).}

\item{\code{ICL}}{Numeric. Value of ICL (Integrated Completed Likelihood).}

\item{\code{AIC}}{Numeric. Value of AIC (Akaike Information Criterion).}

\item{\code{log_piik_fik}}{Matrix of size \eqn{(m, K)} giving the values of the
logarithm of the joint probability \eqn{P(y_{i}, \ z_{i} = k |
  \boldsymbol{x}, \boldsymbol{\Psi})}{P(y_{i}, z_{i} = k | x, \Psi)}, \eqn{i
  = 1,\dots,m}.}

\item{\code{log_sum_piik_fik}}{Column matrix of size \emph{m} giving the values of
\eqn{\textrm{log} \sum_{k = 1}^{K} P(y_{i}, \ z_{i} = k | \boldsymbol{x},
  \boldsymbol{\Psi})}{log \sum_{k = 1}^{K} P(y_{i}, z_{i} = k | x, \Psi)},
\eqn{i = 1,\dots,m}.}
}}

\section{Methods}{

\describe{
\item{\code{computeLikelihood(reg_irls)}}{Method to compute the log-likelihood. \code{reg_irls} is the value of
the regularization part in the IRLS algorithm.}

\item{\code{computeStats(paramMRHLP)}}{Method used in the EM algorithm to compute statistics based on
parameters provided by the object \code{paramMRHLP} of class
\link{ParamMRHLP}.}

\item{\code{EStep(paramMRHLP)}}{Method used in the EM algorithm to update statistics based on parameters
provided by the object \code{paramMRHLP} of class \link{ParamMRHLP}
(prior and posterior probabilities).}

\item{\code{MAP()}}{MAP calculates values of the fields \code{z_ik} and \code{klas}
      by applying the Maximum A Posteriori Bayes allocation rule.

      \eqn{z_{ik} = 1 \ \textrm{if} \ k = \textrm{arg} \ \textrm{max}_{s}
      \ \pi_{s}(x_{i}; \boldsymbol{\Psi});\ 0 \ \textrm{otherwise}}{
      z_{ik} = 1 if z_ik = arg max_{s} \pi_{k}(x_{i}; \Psi); 0 otherwise}}
}}

\seealso{
\link{ParamMRHLP}
}
