% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_RuleBook.R
\name{get_RuleBook}
\alias{get_RuleBook}
\title{Get One of a Series of Predefined Rule Books for a Model Run.}
\usage{
get_RuleBook(book = "empty", osl = NULL)
}
\arguments{
\item{book}{\link{character} value, name of the rule book to be generated.
One out of \code{"empty"}, default is \code{"empty"}.}

\item{osl}{\link{character} value, optional keyword for an OSL (optical
stimulated luminescence) model of choice. Must be one of the available
models from the R package \code{RLumModel}. See details for full list of
available models.}
}
\value{
A \link{list} object with all rules for a model run.
}
\description{
The function returns a pre-built model rule book, i.e., a combination of
model parameters and rules.
}
\details{
It is possible to generate OSL-tailored rule books. For this, the
argument \code{osl} must be provided with a keyword defining one of the
OSL models from the R package \code{'RLumModel'}: \code{"Bailey2001"},
\code{"Bailey2004"}, \code{"Pagonis2008"}, \code{"Pagonis2007"},
\code{"Bailey2002"} and \code{"Friedrich2017"}. The model parameters will
be appended to the rule book entries and defined by mean and standard
deviation.
}
\examples{

## create simple true age-depth-relationship
book_flat <- get_RuleBook(book = "empty")

}
\author{
Michael Dietze, GFZ Potsdam (Germany), Sebastian Kreutzer, Geography & Earth
Sciences, Aberystwyth University (United Kingdom)
}
