% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_SAR_OSL.R
\name{measure_SAR_OSL}
\alias{measure_SAR_OSL}
\title{Measure an aliquot with the CW SAR OSL protocol}
\usage{
measure_SAR_OSL(aliquot, sequence, dose_rate = 0.1)
}
\arguments{
\item{aliquot}{\link{data.frame} or a \link{list} of it, a set of grains that are assigned to an
aliquot (sample subset used for measurement), i.e., the result of
\link{prepare_Aliquot}.}

\item{sequence}{\link{list}, definition of the SAR protocol.}

\item{dose_rate}{\link{numeric} value, Dose rate of the luminescence
reader, in Gy/s.}
}
\value{
\link[Luminescence:RLum.Analysis-class]{Luminescence::RLum.Analysis} object. Equivalent of the import result for
a real world measurement file. This object can be evaluated by functions
of the package \code{Luminescence-package}.
}
\description{
The function models the time-dependent photon counts of an aliquot
according to the specified CW SAR OSL (continuous wave, single aliquot
regenerative dose protocol for optically stimulated luminescence) sequence
and parameters. The modelling is done for each component and photon count
curves are summed to return an \link[Luminescence:RLum.Analysis-class]{Luminescence::RLum.Analysis} object as equivalent of
importing a real measurement data set to the R-package \code{Luminescence-package}.

The function uses the package \code{RLumModel} to perform the simulation of the
photon count curves.
}
\examples{

\dontrun{

## load example data set
data(sample_osl_aliquots, envir = environment())

sequence <- list(
  RegDose = c(0, 1, 2, 5, 10, 0, 1),
  TestDose = 2,
  PH = 220,
  CH = 200,
  OSL_temp = 125,
  OSL_duration = 70)

## reduce number of 
## grains to two
sample_osl_aliquots$aliquot_1 <- 
sample_osl_aliquots$aliquot_1[1:2,]

## or measure all aliquots in a row
sar_all <- measure_SAR_OSL(
 aliquot = sample_osl_aliquots,
 sequence = sequence,
 dose_rate = 0.1)
 
 }

}
\author{
Michael Dietze, GFZ Potsdam (Germany),
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
}
