% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_Sieving.R
\name{prepare_Sieving}
\alias{prepare_Sieving}
\title{Sieve a Sample}
\usage{
prepare_Sieving(sample, interval)
}
\arguments{
\item{sample}{\link{data.frame} sample object to be sieved.}

\item{interval}{\link{numeric} vector, sieve interval, in phi units.}
}
\value{
\link{data.frame} with grains that are within the sieve interval.
}
\description{
The function removes grains that are not within the provided sieve
interval.
}
\examples{
## load example data set
data(sample, envir = environment())

## sieve sample (in phi units)
sample_sieved <- prepare_Sieving(
  sample = sample,
  interval = c(5, 6))
                                 
## plot results
plot(density(
  x = sample$grainsize, 
  from = -1, 
  to = 11))
lines(density(
  x = sample_sieved$grainsize, 
  from = -1, 
  to = 11), 
  col = 2)

}
\author{
Michael Dietze, GFZ Potsdam (Germany)
}
