% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transliterate_dataset.R
\docType{package}
\name{transliterate_dataset}
\alias{transliterate_dataset}
\title{sanketphonetictranslator}
\usage{
transliterate_dataset(dataset, direction)
}
\arguments{
\item{dataset}{= The name of dataset to be transliterated.}

\item{direction}{= The direction of transliteration. Use "hindi2english" to transliterate from Hindi to English, or "english2hindi" to transliterate from English to Hindi.}
}
\value{
A data frame with the transliterated text.
}
\description{
Facilitate phonetic transliteration between different languages. With support for both Hindi and English, this package provides a way to convert text between hindi and english dataset. Whether you're working with multilingual data or need to convert dataset for analysis or presentation purposes, it offers a simple and efficient solution. Harness the power of phonetic transliteration in your projects with this versatile package.
}
\details{
sanketphonetictranslator
}
\examples{
# Load the dataset (assuming it's already loaded or available in your environment)
data <- dataset

# Transliterate the dataset from Hindi to English
translated_data <- transliterate_dataset(data, "hindi2english")

# View the first few rows of the translated dataset
head(translated_data)

}
\seealso{
\code{\link{dataset}}
}
\author{
Sanket Gharat
}
