% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trios.R
\name{sanzo.trio}
\alias{sanzo.trio}
\title{Generate three-colored palettes}
\usage{
sanzo.trio(palette_name)
}
\arguments{
\item{palette_name}{The short ID for the palette, e.g. "c121". For full list of trio IDs, use sanzo.info3().}
}
\value{
A vector of hexademicals of length 3.
}
\description{
Generate three-colored palettes.
}
\examples{
# Assign palette to a name.
my_palette <- sanzo.trio("c223")

# Concatenate two trios for a custom six-colored palette.
c207 <- sanzo.trio("c207")
c226 <- sanzo.trio("c226")
custom_six <- c(c207, c226)

# Use with base R.
plot(iris$Sepal.Width,
     iris$Sepal.Length,
     col = sanzo.trio("c343"))

# For examples of use with ggplot2, see https://github.com/jmaasch/sanzo.

# For examples of use as a gradient, see https://github.com/jmaasch/sanzo.

}
