% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getColoursPercentage.R
\name{getColoursPercentage}
\alias{getColoursPercentage}
\title{Gets colours for plotting the snow layer property 'percentage'}
\usage{
getColoursPercentage(
  Values,
  Resolution = 101,
  Min = 0,
  Max = 1,
  ClrRamp = c("Blues", "Greys", "Greys_transparent")[1]
)
}
\arguments{
\item{Values}{of the 'percentage' variable}

\item{Resolution}{Resolution of colour scale. Default is 100.}

\item{Min}{Minimum values of the percentage (for colouring)}

\item{Max}{Maximum --=--}

\item{ClrRamp}{Three different colourmaps can be chosen from: "Blues", "Greys", "Greys_transparent"}
}
\value{
Array with HTML colour codes
}
\description{
Gets colours for plotting the snow layer property 'percentage', as used for example for distributions from 0--1.
}
\examples{

prct <- seq(0, 1, by=0.1)
plot(x = rep(1,length(prct)), y = prct,
     col = getColoursPercentage(prct), pch = 19, cex = 3)

plot(x = rep(1,length(prct)), y = prct,
     col = getColoursPercentage(prct, ClrRamp = "Greys"), pch = 19, cex = 3)


}
\seealso{
\link{getColoursGrainSize}, \link{getColoursGrainType}, \link{getColoursHardness}, \link{getColoursLWC}, \link{getColoursSnowTemp}, \link{getColoursStability}
}
\author{
fherla
}
