% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unobservedBasalLayer.R
\name{insertUnobservedBasalLayer}
\alias{insertUnobservedBasalLayer}
\title{Insert a special layer at the bottom to indicate a snow profile that's unobserved from a specific point down to the ground
internal function, not exported. used in snowprofileLayers}
\usage{
insertUnobservedBasalLayer(object, basal_offset, setBasalThicknessNA = FALSE)
}
\arguments{
\item{object}{\link{snowprofileLayers} object}

\item{basal_offset}{a positive numeric scalar indicating the thickness of the basal unobserved layer(s)}

\item{setBasalThicknessNA}{boolean TRUE/FALSE indicating whether the thickness of the inserted layer should be \code{basal_offset} or \code{NA}.
Setting the thickness to NA corresponds to setting a flag that the depth of the profile (i.e., the unobserved basal layers) is unknown.
This often happens in manual profiles which only observe the uppermost meter (or so) of the snowpack}
}
\value{
same object with basal layer inserted as individual row in the data.frame
}
\description{
Insert a special layer at the bottom to indicate a snow profile that's unobserved from a specific point down to the ground
internal function, not exported. used in snowprofileLayers
}
\author{
fherla
}
