% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deliberate.civil.r
\name{deliberate.civil}
\alias{deliberate.civil}
\title{Deliberation function for civil trials (proposed)}
\usage{
deliberate.civil(p_votes, jury_n)
}
\arguments{
\item{p_votes}{Initial number of votes for plaintiff.}

\item{jury_n}{Size of the jury (i.e. 4, 6, 8, 12, or 16).}
}
\value{
Returns "P" (plaintiff verdict) or "D" (defendant verdict).
}
\description{
The deliberate function returns a jury verdict based on a simulation of deliberation
        as a tug-of-war between two verdict factions. The civil version of deliberate does not have
        presumption in favor of either party. Can be called directly, but is meant to be called
        many times to generate verdict probabilities based on p_votes and jury_n values.
}
\examples{
   library(sate)
   deliberate.civil(p_votes=8, jury_n=12)

   deliberate.civil(p_votes=5, jury_n=6)
}
