% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition.matrix.ordered.R
\name{transition.matrix.ordered}
\alias{transition.matrix.ordered}
\title{Build column-stochastic transition matrix for ordered verdict options}
\usage{
transition.matrix.ordered(jury_n, verdict_options, digits = NULL)
}
\arguments{
\item{jury_n}{Integer. Size of the jury (number of jurors), `jury_n >= 1`.}

\item{verdict_options}{Character vector of **ordered** verdict labels from least to most
punitive, e.g. `c("NG","M2","M1")` or `c("NG","M3","M2","M1")`. The order defines
which options are adjacent.}

\item{digits}{Optional integer. If supplied, round the returned matrix to this many
decimals and then re-normalize each column to remain column-stochastic. Defaults to
`NULL` (no rounding).}
}
\value{
A column-stochastic matrix `P` of size \eqn{S \times S}, where
  \eqn{S = \binom{n+K-1}{K-1}} is the number of compositions of `jury_n` into `K`
  parts (all states), ordered with **transients first** and then the `K` unanimity
  absorbing states in the order of `verdict_options`. The matrix carries metadata on
  `attr(P, "meta")` as a list with elements:
  \itemize{
    \item `states` — list of length-`K` integer count vectors for each state, in column order;
    \item `idx` — environment mapping comma-joined count vectors to column/row indices;
    \item `T`, `S`, `K`, `n` — counts (transients, total states, #options, #jurors);
    \item `verdict_options` — the label vector you supplied.
  }
}
\description{
Constructs the full **column-stochastic** Markov transition matrix \(P\) for a jury
deliberation model with an **ordered** set of verdict options (least → most punitive).
Transient states are all compositions of `jury_n` jurors across the `verdict_options`;
absorbing states are the `K` unanimity vertices (one per verdict), appended at the end
in the same order as `verdict_options`.

The transition from a transient state is built by applying your **2-option step rule**
independently at each adjacent *cut* between options and combining those suggestions
with **equal weight across cuts**. For cut `r` (between options `r` and `r+1`), let
`g = sum(counts[(r+1):K])` be the number on the **more punitive** side; compute
\deqn{p_\text{up} = \left(0.5\frac{g-1}{n} + 0.25\right)^2,\quad
      p_\text{down} = \left(1 - 0.5\frac{g-1}{n} - 0.25\right)^2,\quad
      p_\text{stay} = 1 - p_\text{up} - p_\text{down}.}
Map “up” to moving one juror across the cut toward the more punitive option, “down”
toward the less punitive option; pool all “stay” mass (and any illegal move mass at
boundaries) into the **self-loop** so each column still sums to 1.
}
\details{
* Absorbing columns (the last `K`) are identity columns (unanimity stays put).
* Self-loops collect “stay” mass from all cuts and any mass from moves that are illegal
  at boundaries (e.g., trying to move from an empty option).
* Providing `digits` is meant for tidy printing; for numerical work you may prefer to
  leave `digits = NULL` to keep full precision.
}
\examples{
# 3 jurors, 3 options (NG < M2 < M1), equal cut weights
P <- transition.matrix.ordered(3, c("NG","M2","M1"))
dim(P); colSums(P)                        # columns sum to 1
attr(P, "meta")$verdict_options           # labels carried in metadata

# Tidy print:
transition.matrix.ordered(3, c("NG","M2","M1"), digits = 3)

# 4 options (NG < M3 < M2 < M1)
P4 <- transition.matrix.ordered(3, c("NG","M3","M2","M1"))

}
\seealso{
\code{\link{prob.ordered.verdicts}} for solved absorption probabilities
  (including appended unanimity starts) built on top of this transition matrix.
}
