% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scinsight.R
\name{run_scINSIGHT}
\alias{run_scINSIGHT}
\title{Perform scINSIGHT on normalized datasets}
\usage{
run_scINSIGHT(
  object,
  K = seq(5, 15, 2),
  K_j = 2,
  LDA = c(0.001, 0.01, 0.1, 1, 10),
  thre.niter = 500,
  thre.delta = 0.01,
  num.cores = 1,
  B = 5,
  out.dir = NULL,
  method = "increase"
)
}
\arguments{
\item{object}{\code{scINSIGHT} object.}

\item{K}{Number of common gene modules. (default \code{c(5, 7, 9, 11, 13, 15)})}

\item{K_j}{Number of dataset-specific gene modules. (default 2)}

\item{LDA}{Regularization parameters. (default \code{c(0.001, 0.01, 0.1, 1, 10)})}

\item{thre.niter}{Maximum number of block coordinate descent iterations to perform. (default 500)}

\item{thre.delta}{Stop iteration when the reduction of objective function is less than the threshold. (default 0.01)}

\item{num.cores}{Number of cores used for optimizing factorizations in parallel (default 1).}

\item{B}{Number of repeats with random seed from 1 to B. (default 5)}

\item{out.dir}{Output directory of scINSIGHT results. (default NULL)}

\item{method}{Method of updating the factorization (default "increase"). If provide multiple \eqn{K}, user can choose method between "increase" and "decrease".

For "increase", the algorithm will first perform factorization with the least \eqn{K=K_1}. Then initialize \eqn{K_2-K_1} facotrs,
 where \eqn{K_2} is the \eqn{K} sightly larger than \eqn{K_1}, and perform facotrization with these new facotrs. Continue this process until the largest \eqn{K}.

For "increase", the algorithm will first perform factorization with the largest \eqn{K=K_1}. Then choose \eqn{K_2} facotrs,
 where \eqn{K_2} is the \eqn{K} sightly less than \eqn{K_1}, and perform facotrization with these new facotrs. Continue this process until the least \eqn{K}.}
}
\value{
\code{scINSIGHT} object with \eqn{W_1}, \eqn{W_2}, \eqn{H}, \eqn{V} and parameters slots set.
}
\description{
Perform INterpreting single cell gene expresSIon bioloGically Heterogeneous daTa (scINSIGHT) to return factorized \eqn{W_{\ell1}}, \eqn{W_{\ell2}}, \eqn{H} and \eqn{V} matrices.

This factorization produces a \eqn{W_{\ell1}} matrix (cells by \eqn{K_j}), a \eqn{W_{\ell2}} matrix (cells by \eqn{K}), a shared \eqn{V} matrix (\eqn{K} by genes)
for each sample, and a \eqn{H} (\eqn{K_j} by genes) matrix for each condition. \eqn{W_{\ell2}} are the expression matrices of \eqn{K} common gene modules for all samples,
\eqn{V} is the membership matrix of \eqn{K} common gene modules, and it's shared by all samples.
\eqn{W_{\ell1}} are the expression matrices of \eqn{K_j} condition-specific gene modules for all samples,
and \eqn{H} are the membership matrices of \eqn{K_j} condition-specific gene modules for all conditions.
}
