% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SeuratPreprocess.R
\name{SeuratPreprocess}
\alias{SeuratPreprocess}
\title{Preprocess count data and create a Seurat object}
\usage{
SeuratPreprocess(
  counts_data,
  meta.data = NULL,
  batch_column = NULL,
  use_fastMNN = FALSE,
  ...
)
}
\arguments{
\item{counts_data}{A matrix or data frame of count data.}

\item{meta.data}{A data frame containing metadata to include in the Seurat object. Default is NULL.}

\item{batch_column}{A vector or factor specifying batch assignments for each cell. Default is NULL.}

\item{use_fastMNN}{Logical. Whether to apply batch correction using fastMNN. Default is FALSE.}

\item{...}{Additional arguments to be passed to Seurat::CreateSeuratObject.}
}
\value{
A Seurat object.
}
\description{
This function preprocesses count data, optionally applying batch correction using batchelor::fastMNN,
and creates a Seurat object.
}
\examples{
\donttest{
library(Seurat)
# Read 10X counts data from matrix.mtx, barcodes.tsv and genes.tsv
counts <- Read10X(data.dir = "../inst/extdata", gene.column = 1)

# Create Seurat object without batch correction
seurat_obj <- SeuratPreprocess(counts)
}
}
