% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSE129785_SU008_Tumor_Pre.R
\docType{data}
\name{GSE129785_SU008_Tumor_Pre}
\alias{GSE129785_SU008_Tumor_Pre}
\alias{SU008_Tumor_Pre_fragmentoverlap}
\alias{SU008_Tumor_Pre_windowcovariates}
\alias{rescnv}
\title{Basal cell carcinoma sample SU008_Tumor_Pre}
\format{
\code{SU008_Tumor_Pre_fragmentoverlap} is a dataframe of fragmentoverlap.

\code{SU008_Tumor_Pre_windowcovariates} is a dataframe of windows and peaks.

\code{rescnv} is a list containing the output of cnv function.
}
\source{
\href{https://www.ncbi.nlm.nih.gov/geo/}{GEO, GSE129785}
}
\usage{
data(GSE129785_SU008_Tumor_Pre)

SU008_Tumor_Pre_windowcovariates

rescnv
}
\description{
The dataset includes 788 nuclei obtained from
basal cell carcinoma sample SU008_Tumor_Pre.
Overlapping of single-nucleus ATAC-seq fragments was computed with the
\code{fragmentoverlapcount} function.
}
\examples{
\dontrun{
data(GSE129785_SU008_Tumor_Pre)
levels = c(2, 4)
result = cnv(SU008_Tumor_Pre_fragmentoverlap,
             SU008_Tumor_Pre_windowcovariates,
             levels = levels,
             deltaBICthreshold = -600)
}
}
\references{
Satpathy et al. (2019) Nature Biotechnology 37:925 \doi{10.1038/s41587-019-0206-z}
}
\keyword{datasets}
