% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scSorter.R
\name{scSorter}
\alias{scSorter}
\title{scSorter}
\usage{
scSorter(
  expr,
  anno,
  default_weight = 2,
  n_start = 10,
  alpha = 0,
  u = 0.05,
  max_iter = 100,
  setseed = 0
)
}
\arguments{
\item{expr}{A matrix of the input expression data. Each row represents a gene and each column represents a cell. Each row of this matrix should be named by the gene name it represents.}

\item{anno}{A matrix or data frame that contains marker genes specified for cell types of interest.
It should contain three columns named "Type", "Marker", and "Weight" that records the name and weight of marker genes specified for each cell type.
"Weight" column is optional. If it is not specified, the \code{default_weight} will be applied to all marker genes.}

\item{default_weight}{The default weight assigned to marker genes. The default value is 2.}

\item{n_start}{The number of possible cluster initializations. The default value is 10.}

\item{alpha}{The parameter determines the cutoff whether the cell type of a cell should be considered as undecided during unknown cell calling. The default value is 0.}

\item{u}{The parameter determines whether undecided cells are further processed. The default value is 0.05.}

\item{max_iter}{The maximum number of iterations for the algorithm to update parameters. The default value is 100.}

\item{setseed}{Random seed for cluster initialization. The default value is 0.}
}
\value{
A list contains the elements:
 \code{Pred_Type}: The predicted cell types.
 \code{Pred_param}: The parameter estimates of \code{mu} and \code{delta}.
}
\description{
This is the main function that implements the scSorter method.
}
\examples{
load(system.file('extdata', 'example_data.RData', package = 'scSorter'))
result = scSorter(expr, anno)
misclassification_rate = 1 - mean(result$Pred_Type == true_type)
table(result$Pred_Type, true_type)

}
