#include "scalablebayesm.h"
#include <RcppArmadillo.h>

using namespace Rcpp;
using namespace arma;

int rmultinomF(arma::vec const& p); 

//[[Rcpp::export]]
Rcpp::List drawPosteriorParallel_cpp(Rcpp::List const& compdraw, arma::mat const& probdraw,arma::mat const& Deltadraw,
                                     arma::mat const& V, int R,  int s, int post_burn_in, int keep,arma::mat const& Z, bool drawdelta)
{//####check:delet int nvar
  //
  // found in rhiermnlrwmixture parallel in rico's bayesm package
  // ORIGINAL
  // //draw from posterior predictive density
  // int ndraws = ceil((float)R * s);
  // mat betadraw(ndraws, nvar);
  // int ncompdraw = floor((R-B)/keep);
  // ivec r = randi(ndraws, distr_param(0,ncompdraw-1));
  
  // List compdrawi, compdrawi0;
  // mat root;
  // vec mu;
  // int indp;
  
  // for(int i = 0; i<ndraws; i++){
  //   compdrawi = compdraw[r[i]];
  //   indp = rmultinomF(trans(probdraw(r[i], span::all)));
  //   compdrawi0 = compdrawi[indp-1]; 
  //   mat rooti = compdrawi0["rooti"];
  //   vec mu = compdrawi0["mu"];
  //   root = solve(trimatu(rooti), eye(nvar,nvar));
  //   betadraw.row(i) = trans(mu + trans(root) * as<vec>(rnorm(nvar)));
  // }
  
  // Kevin Nguyen 8/25/2022
  // Boyang Yu 06/2023
  int nvar=V.n_cols;
  // int ndraws = ceil((float)R / s);
  int ndraws = ceil((float) R );
  mat betadraw(ndraws, nvar);
  mat betabar;
  mat olddelta;
  int ncompdraw = floor((float)post_burn_in/keep);
  int n=Z.n_rows;
  int nz=Z.n_cols;

  
  
  ivec r = randi(ndraws, distr_param(0,ncompdraw-1)); 
  uvec zr = randi<uvec>(ndraws, distr_param(0, n-1));//An uvec object can hold a collection of non-negative integer values (including zero) and provides various operations and functions that can be applied to the vector, such as element-wise arithmetic, logical operations, and more.
  //generate ndraws elements in the vector zr with random distribution

  Rcpp::List compdrawi, compdrawi0;
  arma::mat root;
  vec mu;
  int indp;
 //include n.rows for Z

  // check if probdraw if single component mixture
 // for(int i = 0; i<ndraws; i++) {
 //   compdrawi = compdraw[r[i]];
//    indp = rmultinomF(trans(probdraw(r[i], span::all)));//Pick which compoent to use
//   compdrawi0 = compdrawi[indp-1];
//   arma::mat rooti = compdrawi0["rooti"];
//    vec mu = compdrawi0["mu"];
//    root = solve(trimatu(rooti), eye(nvar,nvar));
    //add code about the delta and randomply choose Z (code in email). 
    //use if function
    //*Be careful, when we don't include delta, we don't need betabar
    //*If we include delta, we need a betabar (from book p.132) (Replace betabar to u in this situation)
//    betadraw.row(i) = trans(mu + trans(root) * as<arma::vec>(rnorm(nvar)));//random draw in matrix version 
//  }
 for(int i = 0; i<ndraws; i++) {

    compdrawi = compdraw[r[i]];
    indp = rmultinomF(trans(probdraw(r[i], span::all)));
    compdrawi0 = compdrawi[indp-1];
    arma::mat rooti = compdrawi0["rooti"];
    vec mu = compdrawi0["mu"];
    root = solve(trimatu(rooti), eye(nvar,nvar));
 
    //note: beta_i = Delta*z_i + u_i  Delta is nvar x nz
    if (drawdelta){
     
      olddelta = Deltadraw(r[i],span::all);
      olddelta.reshape(nvar,nz);

      betabar = mu+olddelta*vectorise(Z(zr(i),span::all));

    }else{
      betabar = mu;
    }

    betadraw.row(i) = trans(betabar + trans(root) * as<arma::vec>(rnorm(nvar)));
}
  
  return(Rcpp::List::create(Rcpp::Named("betadraw") = betadraw));
}

