#ifndef __SCALABLEBAYESM_H__
#define __SCALABLEBAYESM_H__

#include <RcppArmadillo.h>
#include <Rcpp.h>
//#include <stdio.h>
//#include <time.h>

using namespace arma;
using namespace Rcpp;

struct mnlMetropOnceOut{
  arma::vec betadraw;
  int stay;
  double oldll;
};

struct moments{
  arma::vec y;
  arma::mat X;
  arma::mat XpX;
  arma::vec Xpy;
  arma::mat hess;
};

//Used in rDPGibbs, rhierMnlDP, rivDP, and utilityFunctions.cpp
struct lambda{
  vec mubar;
  double Amu;
  double nu;
  mat V;
};

//Used  in rDPGibbs, rhierMnlDP, rivDP, and utilityFunctions.cpp
 struct murooti{
   vec mu;
   mat rooti;
 };

//Used in rhierMnlDP, rivDP
struct DPOut{
  ivec indic;
  std::vector<murooti> thetaStar_vector;
  std::vector<murooti> thetaNp1_vector;
  double alpha;
  int Istar;
  lambda lambda_struct;
};

//Used in rHDPGibbs
//struct HDPOut {
//  std::vector<std::vector<murooti>> thetaStar_vectors;
//  std::vector<ivec> indic_vectors; 
//  std::vector<murooti> thetaNp1_vectors;
//  vec alpha;
//  lambda lambda_struct;
//};

//Used in rDPGibbs, rhierMnlDP, rivDP, and utilityFunctions.cpp
struct priorAlpha{
  double power;
  double alphamin;
  double alphamax;
  int n;
};

 struct thetaStarIndex{
   ivec indic;
   std::vector<murooti> thetaStar_vector;
 };

//Used in rhierLinearMixture, rhierLinearModel, rhierMnlRWMixture, and utilityFunctions.cpp
 struct unireg{
   vec beta;
   double sigmasq;
 };

void startMcmcTimer();
void infoMcmcTimer(int rep, int R);
void endMcmcTimer();
List rwishart(int const& nu, mat const& V);
List rmultireg(mat const& Y, mat const& X, mat const& Bbar, mat const& A, int nu, mat const& V);
List drawCompsFromLabels(mat const& y,  mat const& Bbar, mat const& A, int nu, mat const& V,  int ncomp,vec const& z);
vec rdirichlet(vec const& alpha);
vec drawLabelsFromComps(mat const& y, vec const& p, List comps);
vec drawPFromLabels1(vec const& a, vec const& z);
List rmixGibbs1( mat const& y,  mat const& Bbar, mat const& A, int nu, mat const& V,  vec const& a, vec const& p,  vec const& z);
double llmnl(vec const& beta, vec const& y, mat const& X);
double ll_linear(vec const& beta, vec const& y, mat const& X);
double lndMvn(vec const& x, vec const& mu, mat const& rooti);
mnlMetropOnceOut mnlMetropOnce(arma::vec const& y, arma::mat const& X, arma::vec const& oldbeta, double oldll, double s, arma::mat const& incroot, arma::vec const& betabar, arma::mat const& rootpi);
mat drawDelta1(mat const& x,mat const& y,vec const& z,List const& comps,vec const& deltabar,mat const& Ad);
mat drawDeltaDP(mat const& x,mat const& y,ivec const& z,std::vector<murooti> const& comps_vector,vec const& deltabar,mat const& Ad);

vec q01(mat const& y, lambda const& lambda_struct);
mat yden(std::vector<murooti> const& thetaStar_vector, mat const& y);
ivec numcomp(ivec const& indic, int k);
int rmultinomF(vec const& p);
murooti thetaD1(mat const& y, lambda const& lambda_struct);
thetaStarIndex thetaStarDraw(ivec indic, std::vector<murooti> thetaStar_vector, mat const& y, mat ydenmat, vec const& q0v, double alpha, 
                             lambda const& lambda_struct, int maxuniq);
thetaStarIndex thetaStarDraw(ivec indic, std::vector<murooti> thetaStar_vector, mat const& y, mat ydenmat, vec const& q0v, double alpha, 
                             lambda const& lambda_struct, int maxuniq);
murooti GD1(lambda const& lambda_struct);
vec seq_rcpp(double from, double to, int len);
double alphaD(priorAlpha const& priorAlpha_struct, int Istar, int gridsize);
lambda lambdaD(lambda const& lambda_struct, std::vector<murooti> const& thetaStar_vector, vec const& alim, vec const& nulim, vec const& vlim, int gridsize);
DPOut rDPGibbs1(mat y, lambda lambda_struct, std::vector<murooti> thetaStar_vector, int maxuniq, ivec indic, 
                vec q0v, double alpha, priorAlpha const& priorAlpha_struct, int gridsize, List const& lambda_hyper);
//HDPOut rHDPGibbs(mat y, std::vector<lambda> lambda_structs, std::vector<std::vector<murooti>> thetaStar_vectors, 
//                 int maxuniq, std::vector<ivec> indic_groups, vec q0v, 
//                 double alpha0, std::vector<double> alpha1s, priorAlpha const& priorAlpha_struct, 
//                 int gridsize, List const& lambda_hyper);
unireg runiregG1(vec const& y, mat const& X, mat const& XpX, vec const& Xpy, double sigmasq, mat const& A, 
                vec const& Abetabar, int nu, double ssq);

#endif
