% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get_thresh}
\alias{get_thresh}
\title{Get Thurstone thresholds}
\usage{
get_thresh(pars, itemtype, item_ind, alpha = 1)
}
\arguments{
\item{pars}{Vector of estimated item parameters}

\item{itemtype}{Item type: "1PL", "PCM", or "PCM2".}

\item{item_ind}{Vector with one element for each parameter indicating which
item each parameter is associated with.}

\item{alpha}{Vector of item steepnesses, with one element for each item.
Recycled if of length 1.}
}
\value{
Vector of Thurstone thresholds
}
\description{
Find Thurstone thresholds from a fitted model.
}
\examples{

if(require(TAM)){

set.seed(2524)

diff <- rnorm(10)

N <- 500

th <- rnorm(N)

probs <- 1 / (1 + exp(-outer(th, diff, "-")))

dat <- apply(probs, 2, function(p) as.numeric(p > runif(N)))

# fit the model

mod <- TAM::tam.mml(resp = dat, irtmodel = "1PL")

get_thresh(mod$xsi$xsi, itemtype = "1PL", item_ind = 1:10)

}

}
