% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{run_scan}
\alias{run_scan}
\title{Run a scan statistic analysis.}
\usage{
run_scan(scanstat, args, gumbel = FALSE)
}
\arguments{
\item{scanstat}{A scan statistic function.}

\item{args}{A named list of arguments to be passed to \code{scanstat}.}

\item{gumbel}{Logical: should a Gumbel P-value be calculated? Default is
\code{FALSE}.}
}
\value{
A list with components
   \describe{
     \item{observed}{The table of observed statistics.}
     \item{simulated}{The table of simulated statistics.}
     \item{MC_pvalue}{The Monte Carlo P-value of the scan statistic.}
     \item{Gumbel_pvalue}{The Gumbel P-value of the scan statistic.}
   }
}
\description{
Run a scan statistic analysis with the given scan statistic and arguments.
}
\keyword{internal}
