% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpGModule.R
\name{cpGModule}
\alias{cpGModule}
\title{Identify cell phenotype activated gene module}
\usage{
cpGModule(
  network.data,
  cellset,
  nperm = 100,
  cut.pvalue = 0.01,
  cut.fdr = 0.05,
  parallel.cores = 2,
  rwr.gamma = 0.7,
  normal_dist = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{network.data}{Network data constructed by the \code{ConNetGNN} function.}

\item{cellset}{A vector of cell id. The specified cell set, which will be used as the restart set.}

\item{nperm}{Number of random permutations. Default: \code{100}.}

\item{cut.pvalue}{The threshold of P-value, and genes below this threshold are regarded as gene modules activated by the cell set. Default: \code{0.01}.}

\item{cut.fdr}{The threshold of false discovery rate (FDR), and genes below this threshold are regarded as gene modules activated by the cell set. Default: \code{0.05}.}

\item{parallel.cores}{Number of processors to use when doing the calculations in parallel (default: \code{2}). If \code{parallel.cores=0}, then it will use all available core processors unless we set this argument with a smaller number.}

\item{rwr.gamma}{Restart parameter. Default: \code{0.7}.}

\item{normal_dist}{Whether to use pnorm to calculate P values. Default: \code{TRUE}.Note that if normal_dist is FALSE, we need to increase nperm (we recommend 100).}

\item{verbose}{Gives information about each step. Default: \code{TRUE}.}
}
\value{
A data frame contains four columns:
\describe{
  \item{Genes}{Gene ID.}
  \item{AS}{Activity score.}
  \item{Pvalue}{Significant P-value.}
  \item{FDR}{False discovery rate.}
}
}
\description{
Mining activated gene modules in specific cell phenotype.
}
\details{
cpGModule


The \code{cpGModule} function takes a user-defined cell set as a restart set to automatically
identify activated gene modules. A perturbation analysis was used to calculate a significant P-value for each gene.
The \code{Benjamini & Hochberg (BH)} method was used to adjust the P-value to obtain the FDR.
Genes with a significance level less than the set threshold are considered as cell phenotype activated gene modules.
}
\examples{
require(parallel)
require(stats)

# Load the result of the ConNetGNN function.
data(ConNetGNN_data)
data(Hv_exp)

# Construct the cell set corresponding to 0h.
index<-grep("0h",colnames(Hv_exp))
cellset<-colnames(Hv_exp)[index]
cpGModule_data<-cpGModule(ConNetGNN_data,cellset,nperm=10,parallel.cores=1)
}
