% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMulPhenGM.R
\name{plotMulPhenGM}
\alias{plotMulPhenGM}
\title{Visualize gene association network graph for activated gene modules under multiple cell phenotypes}
\usage{
plotMulPhenGM(
  data.list,
  network.data,
  vertex.colors = NULL,
  vertex.size = 10,
  vertex.label.cex = 0.8,
  vertex.label.dist = 1,
  vertex.label.color = "black",
  edge.width = 5,
  margin = 0,
  layout = layout_with_lgl,
  legend.position = "bottomright",
  legend.cex = 1.5,
  legend.pt.cex = 3,
  plotgraph = TRUE
)
}
\arguments{
\item{data.list}{a list. Each element represents the \code{cpGModule} function result of a cell phenotype and the names of the lists are the corresponding cell phenotype.}

\item{network.data}{Network data constructed by the \code{ConNetGNN} function.}

\item{vertex.colors}{The fill color of the vertex. The number of colors should match the number of cell phenotypes. If \code{NULL (default)}, the system will automatically assign colors.}

\item{vertex.size}{The size of the vertex. Default: \code{10}.}

\item{vertex.label.cex}{The font size for vertex labels. Default: \code{0.8}.}

\item{vertex.label.dist}{The distance of the label from the center of the vertex. If it is 0 then the label is centered on the vertex. Default: \code{1}.}

\item{vertex.label.color}{The color of the labels. Default: \code{black}.}

\item{edge.width}{The width of the edge. This does not affect the relative size of the edge weights. Default: \code{5}.}

\item{margin}{The amount of empty space below, over, at the left and right of the plot, it is a numeric
vector of length four. Usually values between 0 and 0.5 are meaningful, but negative values
are also possible, that will make the plot zoom in to a part of the graph. If it is shorter than
four then it is recycled. Default: \code{0}.}

\item{layout}{Either a function or a numeric matrix. It specifies how the vertices will be placed on the plot. For details, please refer to the \code{igraph} Package. Default: \code{layout_with_lgl}.}

\item{legend.position}{This places the legend on the inside of the plot frame at the given location. See the \code{legend()} function for details.}

\item{legend.cex}{The font size of legend. Default: \code{1.5}.}

\item{legend.pt.cex}{Expansion factor(s) for the points. Default: \code{3}.}

\item{plotgraph}{Whether to draw the picture. Default: \code{TRUE}. If \code{FALSE}, the image will not be displayed but the network data will be returned in the igraph data format.}
}
\value{
A graph or list.
}
\description{
For multiple cell phenotypes, the \code{plotMulPhenGM} function will display the activated gene modules for each phenotype and show the connection and status of genes in different cell phenotypes.
}
\details{
plotMulPhenGM


If a gene is significantly activated in more than one cell phenotype, we call it a co-activated gene. These co-activated genes are shown on the sector diagram.
Each interval of the sector diagram represents the activation strength of the gene in this cell phenotype relative to other cell phenotypes.
}
\examples{
require(igraph)
require(grDevices)
# Load the result of the ConNetGNN function.
data(ConNetGNN_data)
# Obtain cpGModule results for each cell phenotype.
data(H9_0h_cpGM_data)
data(H9_24h_cpGM_data)
data(H9_36h_cpGM_data)
data.list<-list(H9_0h=H9_0h_cpGM_data,H9_24h=H9_24h_cpGM_data,H9_36h=H9_36h_cpGM_data)
plotMulPhenGM(data.list,ConNetGNN_data)

}
