% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bursts.R
\name{bursts.impose_deadtime}
\alias{bursts.impose_deadtime}
\title{Imposes a deadtime to each segment in a burst.}
\usage{
bursts.impose_deadtime(bursts, deadtime)
}
\arguments{
\item{bursts}{a burst containing segments of dwells and states.}

\item{deadtime}{the briefest possible event in microseconds.}
}
\value{
A modified copy of the original burst
}
\description{
The user specifies a deadtime in microseconds. The function applies
segment.impose_deadtime to each segment in the burst.
(See segment.impose_deadtime for details.)
}
\examples{

infile <- system.file("extdata", "example4.dwt", package = "scbursts")
dwells <- dwt.read(infile)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")
bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")

bursts_d <- bursts.impose_deadtime(bursts, deadtime=0.01)

}
