% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cplot.R
\name{cplot.popen_ts}
\alias{cplot.popen_ts}
\title{Plot Time Series (ts) of P(Open).}
\usage{
cplot.popen_ts(bursts, main = "P(Open) Time Series", ...)
}
\arguments{
\item{bursts}{List of multiple segments}

\item{main}{The title of the plot.}

\item{...}{Options to pass to plot}
}
\description{
Plot Time Series (ts) of P(Open).
}
\examples{

infile <- system.file("extdata", "example1_qub.dwt", package = "scbursts")
dwells <- dwt.read(infile)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")
bursts <- bursts.defined_by_tcrit(dwells_c, 100, units="ms")

cplot.popen_ts(bursts, "P(Open) Time Series, 2018-09-20")

}
