% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{QPsolve}
\alias{QPsolve}
\title{A wrapper to call solve.QP.}
\usage{
QPsolve(D, d, A, b, Aeq, beq)
}
\arguments{
\item{D}{The matrix of the quadratic objective.}

\item{d}{The vector in the linear term of the quadratic objective.}

\item{A}{The matrix of inequality constraints.}

\item{b}{The vector of RHS of the inequalities.}

\item{Aeq}{The matrix of equality constraints.}

\item{beq}{The vector of RHS of the equalities.}
}
\value{
A list with elements described above.
}
\description{
This function takes arguments slightly differently from solve.QP, to make it more
convenient for internal use.  It also implements measures to robustify calls to solve.QP:
\itemize{
\item A rounding hack to prevent a bug in solve.QP that occasionally produces all-NaN
solutions without returning a warning or error.  Rounding has been found to eliminate
\emph{almost} all such bugs.
\item A call to lpSolve's lp() to check feasibility before running solve.QP
\item solve.QP is called within tryCatch to eliminate unwanted crashes.
}
The output of this function is a list with elements
\itemize{
\item \code{flag} is 0 for successful completion, 1 for failure at the LP check stage,
and 2 for failure at the QP stage (usually the "NaN solution" bug).
\item \code{QP} is the list returned by \code{solve.QP}.  If the QP was not run due to
infeasibility, this element is NULL.
}
}
\details{
solve.QP defines its quadratic program as minimizing 1/2 * x'Dx - x'd, subject to
constraints A'x >= b.  Equality constraints have to be in the first rows of A'.

This function minimizes x'Dx - x'd, subject to inequality constraints Ax >= b and
Equality constraints Aeq*x = beq.
}
\keyword{internal}
