% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{BuildAbundanceMatrix}
\alias{BuildAbundanceMatrix}
\title{BuildAbundanceMatrix}
\usage{
BuildAbundanceMatrix(clasif, gr, expgroups = 0L)
}
\arguments{
\item{clasif}{The vector with the number of the cluster each cell belongs to. Usually obtained as L$clasif, being L the object returned by ApplyPAM.
It MUST be a vector of integers with as many components as cells and values in (1..number_of_clusters). Obviously, it can be a named
vector but the group names are not used.}

\item{gr}{A numeric vector with the group (of those designed for the assay) to which each cell belongs to.
Normally obtained with GetSeuratGroups if the assay is in Seurat format. Otherwise, you will have to provide it yourself. It MUST be
vector of integers with as many components as cells and values in (1..number_of_groups). Obviously, it can be a named vector but
the cell names are not used.}

\item{expgroups}{The expected number of groups. If it is left to its default value (which is 0) the number of groups is infered from parameter grname
as the maximum value in it. Otherwise, the passed value is used. This parameter is to prevent the extinction of some groups due to
previous expurge or filtering but whose trail we want to keep, even they are currently empty.}
}
\value{
M(numclusters,numgroups)  A R matrix as many rows as clusters and as many columns as groups
}
\description{
Builds and returns a R matrix with as many rows as clusters and as many columns as groups in the set of cells (individuals).
The entry at row r, column c is the number if individuals of group c which the classifier has identified as belonging to cluster r
}
\examples{
# Sorry, we can't provide examples here since they require the application to a real problem
# and therefore the load of the Seurat or splatter packages. Please, look at example in the
# vignette of this package.
}
