% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_toc.R
\name{drive_toc}
\alias{drive_toc}
\title{Identify all Folders within Specified Google Drive Folder}
\usage{
drive_toc(url = NULL, ignore_names = NULL, quiet = FALSE)
}
\arguments{
\item{url}{(drive_id) Google Drive folder link modified by `googledrive::as_id` to be a true "Drive ID" (e.g., `url = as_id("url text")`)}

\item{ignore_names}{(character) Vector of name(s) of folder(s) to be excluded from list of folders}

\item{quiet}{(logical) Whether to message which folder it is currently listing (defaults to `FALSE`). Complex folder structures will take time to fully process but the informative per-folder message provides solace that this function has not stopped working}
}
\value{
(node / R6) Special object class used by the `data.tree` package
}
\description{
Identifies all sub-folders within a user-supplied Drive folder (typically the top-level URL). Also allows for exclusion of folders by name; useful if a "Backups" or "Archive" folder is complex and a table of contents is unwanted for that folder(s).
}
\examples{
 
\dontrun{
# Supply a single Google Drive folder link to identify all its sub-folders 
drive_toc(url = googledrive::as_id("https://drive.google.com/drive/u/0/folders/your-folder"))
}

}
