% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{scalling}
\alias{scalling}
\title{Converting coefficients of logistic regression into scores for scorecard building}
\usage{
scalling(base, target, model, point = 15, factor = 2, setscore = 660)
}
\arguments{
\item{base}{base input dataframe}

\item{target}{column / field name for the target variable to be passed as string (must be 0/1 type)}

\item{model}{input logistic model from which the coefficients are to be picked}

\item{point}{(optional) points after which the log odds will get multiplied by "factor" (default value is 15)}

\item{factor}{(optional) factor by which the log odds must get multiplied after a step of "points" (default value is 2)}

\item{setscore}{(optional) input for setting offset (default value is 660)}
}
\value{
The function returns a dataframe with the coefficients and scalled scores for each class of all explanatory variables of the model.
}
\description{
The function takes a logistic model as input and scales the coefficients into scores to be used for scorecard generation. The
}
\examples{
data <- iris
suppressWarnings(RNGversion('3.5.0'))
set.seed(11)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
x <- c("Sepal.Length","Sepal.Width","Petal.Length","Petal.Width")
iv_table_list <- iv_table(base = data,target = "Y",num_var_name = x,cat_var_name = "Species")
num_cat <- num_to_cat(base = data,num_woe_table = iv_table_list$num_woe_table)
log_model <- glm(Y ~ ., data = num_cat, family = "binomial")
scaling_tab <- scalling(base = num_cat,target = "Y",model = log_model)
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
